// scriptView.h : interface of the CScriptView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_SCRIPTVIEW_H__B036D139_15EF_11D2_852D_2E9E34000000__INCLUDED_)
#define AFX_SCRIPTVIEW_H__B036D139_15EF_11D2_852D_2E9E34000000__INCLUDED_

#include "script.h"

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class CScriptView : public CEditView
{
public:
	CScriptView();
protected: // create from serialization only
	DECLARE_DYNCREATE(CScriptView)

// Attributes
public:
	CScriptDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CScriptView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	virtual BOOL DestroyWindow();
	protected:
	virtual void OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView);
	//}}AFX_VIRTUAL

#undef _DEBUG // EMP DIKEO

// Implementation
public:
	CFont m_font;
	void doGoto( int iGoto = -1, BOOL bWrappedLines = TRUE, BOOL bSelLine = FALSE );
	virtual ~CScriptView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	DWORD doCalculateChecksum(const TCHAR *szBuf, DWORD dwSeed);
	void doWriteEncryptedBytesV2(CArchive& ar, const TCHAR *szBuf, UINT nLen, DWORD dwFileFlag);
	void doWriteASCIIBytes(CArchive& ar, const TCHAR *szBuf, UINT nLen);
	void doDecryptV2(TCHAR *szBuf, UINT nLen, DWORD dwFileFlag);

// Generated message map functions
protected:
	void doFind( UINT iStartAt, TCHAR *szFind, BOOLEAN bCase, BOOLEAN bReplace );
#ifdef _POCKET
	void OnContextMenu(NMHDR *pNMHDR, LRESULT *pResult);
#endif
	//{{AFX_MSG(CScriptView)
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnEditCopy();
	afx_msg void OnEditCut();
	afx_msg void OnEditPaste();
	afx_msg void OnEditUndo();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnUpdateEditFind(CCmdUI* pCmdUI);
	afx_msg void OnEditFind();
	afx_msg void OnUpdateEditFindall(CCmdUI* pCmdUI);
	afx_msg void OnEditFindall();
	afx_msg void OnEditFindnext();
	afx_msg void OnUpdateEditFindnext(CCmdUI* pCmdUI);
	afx_msg void OnEditFormat();
	afx_msg void OnUpdateEditFormat(CCmdUI* pCmdUI);
	afx_msg void OnEditGoto();
	afx_msg void OnUpdateEditGoto(CCmdUI* pCmdUI);
	afx_msg void OnEditOverview();
	afx_msg void OnUpdateEditOverview(CCmdUI* pCmdUI);
	afx_msg void OnEditSelectall();
	afx_msg void OnUpdateEditSelectall(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditCut(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditPaste(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditUndo(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in scriptView.cpp
inline CScriptDoc* CScriptView::GetDocument()
   { return (CScriptDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SCRIPTVIEW_H__B036D139_15EF_11D2_852D_2E9E34000000__INCLUDED_)
